/*
 * Wavy circles
 * 
 * @author: Mike van der Sanden
 * mikevandersanden.com
 */


// https://github.com/processing/processing4/issues/544#issuecomment-1293100685
import com.jogamp.opengl.GLProfile;
{ GLProfile.initSingleton(); }


Recorder rec;
Waves waves;

void setup() {
  size(1080,1080,P2D);

  rec = new Recorder();
  waves = new Waves();
}

void draw() {
  background(0);
  noStroke();
  noFill();
  
  // Draw waves
  waves.drawWave();
  
  // Handle recording
  rec.handleRecording();
}

void keyPressed() {
  if(key == 'r') {
    rec.toggleRecord();   
  }
}
