/*
 * Wavy circles
 * 
 * @author: Mike van der Sanden
 * mikevandersanden.com
 */

class Waves {
  
  Gradient gradient;
  
  Waves() {
    gradient = new Gradient();
  }
 
 
  void drawWave() {
    // Keep these here so we can modify them if we want
    float minSize = 0;
    float maxSize = 100;
    int numCols = 30;
    int numRows = 8;
    
    // Calculate dynamic parameters for amplitude modulation
    float minSizeWave = sin(radians(frameCount*2)); 
    float currentMinSize = map(-minSizeWave, -1, 1, minSize, maxSize); 
    
    float maxSizeWave = sin(radians(frameCount)); 
    float currentMaxSize = map(maxSizeWave, -1, 1, minSize, maxSize);
    
    // Keep track of number of circles
    int circleCount = 0;
    
    // Loop through each column
    for(int x=0; x<numCols; x++) {
      
      // Calculate the cell width
      float cellW = (width / ((float) numCols-1));
      
      // Caculate the x position for this column
      float posX = cellW * x + - cellW/2;
      
      // Calculate sizes based on a sinusoidal curve
      // Keep track of sizes
      float[] sizes = new float[numRows];
      float sizeSum = 0;
      
      // Loop through al rows
      for (int y = 0; y < numRows; y++) {
        
        // Map this y to where it would be on a full circle
        float phase = map(y, 0, numRows-1, 0, TWO_PI); 
        
        // This is where a lot of the magic happens
        // Manipulate the phase over time to get the waves 
        // Whenever you changes this you'll get a different wave
        phase = phase * 1.5 + radians(frameCount + x*10);
        
        // Map the phase from 0 to 1
        float osc = (sin(phase) + 1) / 2;
        
        // Oscillate sizes between currentMinSize and currentMaxSize
        float size = osc * (currentMaxSize - currentMinSize) + currentMinSize; 
        sizes[y] = size;
        
        // We need this sum in the next step where we remap the sizes to the available height
        sizeSum += size;
      }
      
      
      // Start with y postion zero for each column
      float posY = 0;
      
      // Normalize sizes to fit the available height
      for (int y=0; y < numRows; y++) {
      
        // Create an inner and an outer color based on a the circle count
        // Change color over time using the frameCount
        float colorWave = circleCount + frameCount * .2;
        
        color innerColor = gradient.lerpColors(colorWave);
        color outerColor = gradient.lerpColors(colorWave*1.2);

        // Calculate mapped size
        float mappedSize = sizes[y] / sizeSum * height;
        
        // Draw the circle
        gradient.drawCircularGradient(posX, posY + mappedSize/2, mappedSize/2, innerColor, outerColor);
        
        // Update y position
        posY += mappedSize;
        
        // Keep track of the number of circles
        circleCount++;
      }
    }
  }
}
