/*
 * Wavy circles
 * 
 * @author: Mike van der Sanden
 * mikevandersanden.com
 */

class Recorder {
  
  boolean isRecording = false;
  String recordName = "";

  Recorder() {
    this.recordName = getRecordFileName();
  }
  
  void handleRecording() {
    if(this.isRecording) {
      surface.setTitle("Recording frame: " + str(frameCount));
      saveFrame("render/" + this.recordName + ".png");
    } 
  }
  
  void toggleRecord() {
    this.recordName = getRecordFileName();
    this.isRecording = ! isRecording;  
  }
    
  /**
   * Create a record name for saving
   */
  String getRecordFileName() {
  
    // Folder
    String folder = "";
    folder += (year() + "").substring(2);
    folder += nf(month(), 2);
    folder += nf(day(), 2); 
    
    // Subfolder
    String subfolder = nf(hour(),2) + nf(minute(),2) + nf(second(),2);
  
    // File name
    String sketchName = getClass().getName();
    String fileName = sketchName + "####";
    
    return folder + "_" + subfolder + "/" + fileName;
  }
}
