/*
 * Wavy circles
 * 
 * @author: Mike van der Sanden
 * mikevandersanden.com
 */

class Gradient {
  
  ArrayList<Integer> colors;
  float loopLen = 100;
  
  Gradient() {
    colors = new ArrayList<Integer>();
   
    // Define colors
    colors.add(#FF4D0D);
    colors.add(#AAAAAA);
    colors.add(#444444);
    colors.add(#000000);
    colors.add(#222222);
  }
    
  /**
   * Create a circular gradient by drawing lots of stroked circles next to each other
   */
  void drawCircularGradient(float x, float y, float radius, color innerColor, color outerColor) {
    // Define number of steps
    // More steps means a smoother gradient
    int steps = round(radius * .5);  
    
    for (int i = steps; i > 0; i--) {
      // Radius of this step
      float rStep = radius / steps * i;
      // Lerp color
      float lerpFactor = (float) i / steps;
      color col = lerpColor(outerColor, innerColor, lerpFactor);
      fill(col);
      // Draw the circle, multiply the radius by 2 for diameter
      circle(x, y, rStep * 2);  
    }
  }
  
  
  color lerpColors(float offset) {
    // Keep the gradient moving
    float engine = offset;
  
    // Length of one part
    float partLen = loopLen / colors.size();
  
    // Where are we on the total scope
    float indexInTotal = engine % loopLen;
  
    // Where are we on the current part
    float indexInCurrent = indexInTotal % partLen;
  
    // Which part are we currently in
    int colStartIndex = floor(indexInTotal / partLen);
    int colEndIndex;
    if (colStartIndex < colors.size() - 1) {
      colEndIndex = colStartIndex + 1;
    } else {
      colEndIndex = 0;  // Wrap around to the first color
    }
  
    // What do we need in the lerp
    float indexMapped = map(indexInCurrent, 0, partLen, 0, 1);
  
    // Lerp colors
    return lerpColor(colors.get(colStartIndex), colors.get(colEndIndex), indexMapped);
  }
}
